﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;

namespace CPVanity {
	public class Member {
		public static Color[] colors=new Color[]{Color.White, Color.SandyBrown,
			Color.LightGray, Color.Gold, Color.LightBlue};

		public int AuthorColor;
		public int AuthorityColor;
		public int DebatorColor;
		public int EditorColor;
		public int EnquirerColor;
		public int OrganiserColor;
		public int ParticipantColor;
		public int TotalColor;
		public uint MemberID;
		public bool MVP;
		public int ArticleCount;
		public int TipCount;
		public int BlogCount;
		public int MessageCount;
		public int QuestionCount;
		public int AnswerCount;
		public int CommentCount;

		public Member() { }

		public string Name { get; set; }
		public int Author { get; set; }
		public int Authority { get; set; }
		public int Debator { get; set; }
		public int Editor { get; set; }
		public int Enquirer { get; set; }
		public int Organiser { get; set; }
		public int Participant { get; set; }
		public int Total { get; set; }

		public int GetReputationComponentValue(int index) {
			switch (index) {
				case 0: return Author;
				case 1: return Authority;
				case 2: return Debator;
				case 3: return Editor;
				case 4: return Enquirer;
				case 5: return Organiser;
				case 6: return Participant;
				default: return Total;
			}
		}

		public Color GetReputationComponentColor(int index) {
			switch (index) {
				case 0: return colors[AuthorColor];
				case 1: return colors[AuthorityColor];
				case 2: return colors[DebatorColor];
				case 3: return colors[EditorColor];
				case 4: return colors[EnquirerColor];
				case 5: return colors[OrganiserColor];
				case 6: return colors[ParticipantColor];
				default: return colors[TotalColor];
			}
		}

		public int PlatinumCount {
			get {
				int pc=0;
				if (AuthorColor>=4) pc++;
				if (AuthorityColor>=4) pc++;
				if (DebatorColor>=4) pc++;
				if (EditorColor>=4) pc++;
				if (EnquirerColor>=4) pc++;
				if (OrganiserColor>=4) pc++;
				if (ParticipantColor>=4) pc++;
				return pc;
			}
		}

		public int GetCounterValue(int index) {
			switch (index) {
				case 0: return ArticleCount;
				case 1: return TipCount;
				case 2: return BlogCount;
				case 3: return MessageCount;
				case 4: return QuestionCount;
				case 5: return AnswerCount;
				case 6: return CommentCount;
				default: return 0;
			}
		}
	} 
}

