﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CPVanity {
	public partial class RepGraphForm : Form {
		private Bitmap bmNormal;
		//private Bitmap bmBottom;
		private List<Bitmap> bitmaps=new List<Bitmap>();
		private List<int> heights=new List<int>();
		private int listIndex=0;

		public RepGraphForm() {
			InitializeComponent();
		}

		public Bitmap Bitmap {
			set {
				bmNormal=value;
				pbReputation.Image=bmNormal;
				bitmaps.Add(bmNormal);
				int h=bmNormal.Height;
				heights.Add(h);
#if false
				int w=bmNormal.Width;
				int h=bmNormal.Height;
				bmBottom=new Bitmap(w, h/2);
				using (Graphics g=Graphics.FromImage(bmBottom)) {
					g.DrawImage(bmNormal, new Rectangle(0, 0, w, h/2), new Rectangle(0, h/2, w, h/2),
						GraphicsUnit.Pixel);
				}
#endif
				toolTip1.SetToolTip(pbReputation,
					"Down-arrow to zoom bottom half\nUp-arrow to full view\nESC to close.");
			}
		}

		private void pbReputation_Click(object sender, EventArgs e) {
			Close();
		}

		private void RepGraphForm_KeyDown(object sender, KeyEventArgs e) {
			try {
				if (e.KeyCode==Keys.Down) {
					setZoom(listIndex+1);
					//pbReputation.Image=bmBottom;
				} else if (e.KeyCode==Keys.Up) {
					setZoom(listIndex-1);
					//pbReputation.Image=bmNormal;
				} else {
					Close();
				}
			} catch (Exception exc) {
				string s="listIndex="+listIndex+"\n"+exc.ToString();
				MessageBox.Show(s);
			}
		}

		private void setZoom(int newIndex) {
			if (newIndex<0) return;
			if (newIndex==bitmaps.Count) {
				int w=bmNormal.Width;
				int h=bmNormal.Height;
				int hNew=heights[newIndex-1]*3/4;
				Bitmap bm=new Bitmap(w, hNew);
				if (hNew<h/10) return;
				using (Graphics g=Graphics.FromImage(bm)) {
					g.DrawImage(bmNormal, new Rectangle(0, 0, w, hNew),
						new Rectangle(0, h-hNew, w, hNew), GraphicsUnit.Pixel);
				}
				bitmaps.Add(bm);
				heights.Add(hNew);
			}
			listIndex=newIndex;
			pbReputation.Image=bitmaps[listIndex];
		}
	}
}
