﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.Globalization;			// NumberStyles
using System.Text;
using System.Windows.Forms;

namespace CPVanity {
	public class TableFactory {
		public static Image NoImage=new Bitmap(1, 1);
		public static Image MvpImage=new Bitmap(1, 1);

		public static void log(string s) {
			//Console.WriteLine(s);
		}

		public static DataTable GetArticlesTable(List<Article> articles,
				out long totalViews, out int totalVotes, out int totalBookmarks, out int totalDownloads) {
			//create a new DataTable and set up the column types
			DataTable dt=new DataTable("CPArticles");
			dt.Columns.Add("#", typeof(string));
			dt.Columns.Add("Title", typeof(string));
			dt.Columns.Add("Updated", typeof(DateTime));
			dt.Columns.Add("Views", typeof(int));
			dt.Columns.Add("Downloads", typeof(int));
			dt.Columns.Add("Bookmarks", typeof(int));
			dt.Columns.Add("Votes", typeof(int));
			dt.Columns.Add("Rating", typeof(string));
			dt.Columns.Add("Popularity", typeof(float));
			// add each article to the DataTable
			totalViews=0;
			totalVotes=0;
			totalBookmarks=0;
			totalDownloads=0;
			double totalRating=0.0;
			foreach (Article cpa in articles) {
				DataRow row=dt.NewRow();
				row["Title"]=cpa.Title;
				row["Updated"]=cpa.Updated;
				row["Views"]=cpa.Views;
				totalViews+=cpa.Views;
				double rating=0;
				row["Rating"]=cpa.Rating;
				double.TryParse(cpa.Rating, NumberStyles.AllowDecimalPoint, 
					CultureInfo.InvariantCulture, out rating);
				totalRating+=rating * cpa.Votes;
				row["Votes"]=cpa.Votes;
				totalVotes+=cpa.Votes;
				row["Downloads"]=cpa.Downloads;
				totalDownloads+=cpa.Downloads;
				row["Bookmarks"]=cpa.Bookmarks;
				totalBookmarks+=cpa.Bookmarks;
				row["Popularity"]=cpa.Popularity;
				dt.Rows.Add(row);
			}
			// add a TOTAL row
			DataRow row1=dt.NewRow();
			row1["#"]="TOTAL";
			row1["Title"]="";
			row1["Updated"]=DateTime.Today.AddDays(1).AddTicks(-1);
			row1["Views"]=totalViews;
			totalRating/=totalVotes;
			row1["Rating"]=totalRating.ToString("#.###");
			row1["Votes"]=totalVotes;
			row1["Bookmarks"]=totalBookmarks;
			row1["Downloads"]=totalDownloads;
			row1["Popularity"]=0;
			dt.Rows.Add(row1);

			return dt;
		}

		public static DataTable GetMembersTable(Dictionary<string, Member> members) {
			//create a new DataTable and set up the column types
            DataTable dt = new DataTable("Members");
			dt.Columns.Add("PK", typeof(int));
			dt.Columns.Add("#", typeof(int));
			dt.Columns.Add("Name", typeof(string));
			dt.Columns.Add("MVP", typeof(Image));
			dt.Columns.Add("PlatinumCount", typeof(int));
			dt.Columns.Add("Author", typeof(int));
			dt.Columns.Add("Authority", typeof(int));
			dt.Columns.Add("Debator", typeof(int));
			dt.Columns.Add("Editor", typeof(int));
			dt.Columns.Add("Enquirer", typeof(int));
			dt.Columns.Add("Organiser", typeof(int));
			dt.Columns.Add("Participant", typeof(int));
			dt.Columns.Add("Total", typeof(int));
#if true
			dt.Columns.Add("Articles", typeof(int));
			dt.Columns.Add("Tips", typeof(int));
			dt.Columns.Add("Blogs", typeof(int));
			dt.Columns.Add("Messages", typeof(int));
			dt.Columns.Add("Questions", typeof(int));
			dt.Columns.Add("Answers", typeof(int));
			dt.Columns.Add("Comments", typeof(int));
#endif
			// add each member to the DataTable
			int pk=0;
			foreach (Member member in members.Values) {
                DataRow row=dt.NewRow();
				row["PK"]=pk++;
				row["Name"]=member.Name;
				row["MVP"]=member.MVP?MvpImage:NoImage;
				row["PlatinumCount"]=member.PlatinumCount;
				row["Author"]=member.Author;
				row["Authority"]=member.Authority;
				row["Debator"]=member.Debator;
				row["Editor"]=member.Editor;
				row["Enquirer"]=member.Enquirer;
				row["Organiser"]=member.Organiser;
				row["Participant"]=member.Participant;
				row["Total"]=member.Total;
				row["Articles"]=member.ArticleCount;
				row["Tips"]=member.TipCount;
				row["Blogs"]=member.BlogCount;
				row["Messages"]=member.MessageCount;
				row["Questions"]=member.QuestionCount;
				row["Answers"]=member.AnswerCount;
				row["Comments"]=member.CommentCount;
				dt.Rows.Add(row);
            }
            return dt;
        }
    }
}