﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace LPCodeRecognizer {
	public class HtmlConverter {
		public static Action<string> Logger;

		public static void log(string s) {
			if (Logger!=null) Logger(s);
		}

		public static void debug(string s) {
			// log(s);
		}

		public static string ToHtmlDocument(string text) {
			int preNesting=0;
			string doc=getHead();
			string ss=text.Replace("\r\n", "\n");
			foreach (string s in ss.Split('\n')) {
				for (int last=-1; ; ) {
					last=s.IndexOf("<pre", last+1);		// don't include >, there may be attributes
					if (last<0) break;
					preNesting++;
				}
				for (int last=-1; ; ) {
					last=s.IndexOf("</pre", last+1);	// don't include >, there may be attributes
					if (last<0) break;
					preNesting--;
				}
				if (preNesting==0) {
					doc+=s+"<br />\n";
				} else {
					doc+=s+"\r\n";
				}
			}
			doc+=getTail();
			return doc;
		}

		private static string getHead() {
			string head="<html><head><style>";
			head+="body, p, td { font-family: Verdana, Arial, Helvetica, sans-serif; margin: 5px; font-size: 10pt }\n";
			head+="pre { background-color: #FBEDBB; font-family: 'Courier New', Courier, mono; }\n";
			head+="code { color: #990000; font-family: 'Courier New', Courier, mono; }\n";
			head+="</style></head><body><p>\n";
			return head;
		}
		private static string getTail() {
			return "</p></body></html>";
		}
	}
}
