﻿//==============================================================================================
//
//	LanguageXYZ
//	V2.0
//	by Luc Pattyn, January 2010
//
//	class used by LPCodeRecognizer
//
//==============================================================================================
using System;
using System.Collections.Generic;
using System.Text;

namespace LPCodeRecognizer {
	class LanguageGroupC : Language {
		public LanguageGroupC() : base("cs", "C/C#/C++/C++.CLI/Java/JavaScript", true, 2,
			"many;,|many{}|few$start|few$start|few$start|few<start|few<>|few@start", "", "") {
			// emphasis: few$start against PHP
			AddKeywordsCS();
			AddKeywordsJava();
			AddKeywordsJavaScript();
			AddKeywordsCPP();
			AddKeywordsC();
		}

		// C#: all VS2008 keywords from http://msdn.microsoft.com/en-us/library/x53a06bb.aspx
		public void AddKeywordsCS() {
			Add("#define|#elif|#else|#endif|#endregion|#error|#if|#line|#pragma|#region|#undef|#warning");
			Add("abstract|add|as|base|bool|break|byte|case|catch|char|checked|class|const|continue");
			Add("decimal|default|delegate|do|double|else|enum");
			Add("event|explicit|extern|false|finally|fixed|float|for|foreach|from|get|global|goto|group");
			Add("if|implicit|in|int|into|interface|internal|is|join|let|lock|long|namespace");
			Add("new|null|object|operator|orderby|out|override|params|partial|private|protected|public");
			Add("readonly|ref|remove|return|sbyte|sealed|select|set|short|sizeof|stackalloc|static|string");
			Add("struct|switch|this|throw|true|try|typeof|uint|ulong|unchecked|unsafe|ushort|using");
			Add("value|var|virtual|volatile|void|where|while|yield");
		}

		public void AddKeywordsJava() {
			Add("#define|#elif|#else|#endif|#error|#include|#if|#ifdef|#ifndef|#message|#pragma|#undef|#warning");
			Add("abstract|assert|boolean|break|byte|case|catch|char|class|const");
			Add("continue|default|do|else|enum|extends|final|float");
			Add("for|goto|if|implements|import|instanceof|int|long|native");
			Add("new|package|private|protected|public|return|short|static|strictfp|super");
			Add("switch|synchronized|this|throw|throws|transient|try|void|volatile|while");
		}

		// JavaScript: keywords (copied from CP list)
		public void AddKeywordsJavaScript() {
			Add("abstract|boolean|break|byte|case|catch|char|class|const|continue|debugger|default");
			Add("delete|do|double|else|enum|export|extends|false|final|finally|float|for|function|goto");
			Add("if|implements|import|in|instanceof|int|interface|long|native|new|null|package|private");
			Add("protected|public|return|short|static|super|switch|synchronized|this|throw|throws");
			Add("transient|true|try|typeof|var|void|volatile|while|with");
		}

		// C++: keywords (copied from CP list)
		public void AddKeywordsCPP() {
			Add("#define|#error|#import|#undef|#elif|#if|#using|#else|#ifdef|#line|#endif|#ifndef|#pragma|#region|#endregion");
			Add("#include");
			Add("__abstract|abstract|__alignof|array|__asm|__assume|__based|bool|__box|break|case|catch");
			Add("deprecated|dllexport|dllimport|do|else|enum|event|__event");
			Add("__except|explicit|extern|false|__fastcall|__finally|finally|float|for|each|in|__forceinline");
			Add("friend|__gc|gcnew|generic|goto|__hook|__identifier|if|__if_exists|__if_not_exists");
			Add("__inline|inline|int|__int8|__int16|__int32|__int64|__interface|interface");
			Add("interior_ptr|__leave|literal|long|__m64|__m128|mutable|friend_as|value|interface");
			Add("naked|namespace|new|__nogc|noinline|__noop|noreturn|nothrow|novtable|nullptr|operator|__pin");
			Add("private|__property|property|protected|public|__raise|struct|ref|register|reinterpret_cast");
			Add("return|safecast|__sealed|sealed|selectany|short|signed|__single_inheritance|sizeof|static");
			Add("__stdcall|struct|__super|switch|template|this|thread|throw|true|try|__try|__except");
			Add("__finally|__try_cast|typedef|typeid|typename|__unaligned|__unhook|union|unsigned|using");
			Add("uuid|__uuidof|value|__value|virtual|__virtual_inheritance|void|volatile|__w64");
			Add("__wchar_t|wchar_t|while|double|initonly|int|const_cast|__m128d__m128i__multiple_inheritance");
			Add("__cdecl|char|class|const|continue|__declspec|default|__delegate|delegate|delete|dynamic_cast|static_cast");
			Add("Byte|SByte|Int16|Int32|Int64|UInt16|UInt32|UInt64|Single|Double|Boolean|IntPtr|UIntPtr|Object|String");
			Add("FALSE|false|TRUE|true");
		}

		public void AddKeywordsC() {
		}
	}
}
