﻿//==============================================================================================
//
//	LanguageXYZ
//	V2.0
//	by Luc Pattyn, January 2010
//
//	class used by LPCodeRecognizer
//
//==============================================================================================
using System;
using System.Collections.Generic;
using System.Text;

namespace LPCodeRecognizer {
	class LanguageGroupVB : Language {
		public LanguageGroupVB() : base("vb", "VB/VB.NET/VBscript", false, 2,
			"few;|few{}|few$start|few<start|few@start", "", "") {
			AddKeywordsVB();
			AddKeywordsVBScript();
		}

		// VB.NET: all VS2010 keywords from http://msdn.microsoft.com/en-us/library/dd409611(VS.100).aspx
		public void AddKeywordsVB() {
			Add("#Const|#Else|#ElseIf|#End|#ExternalSource|#If|#Region");
			Add("AddHandler|AddressOf|Aggregate|Alias|And|AndAlso|Ansi|As|Assembly|Auto");
			Add("Binary|Boolean|By|ByRef|Byte|ByVal");
			Add("Call|Case|Catch|CBool|CByte|CChar|CDate|CDbl|CDec|CChar|CInt|Class|CLng|CObj|Compare|Const");
			Add("Constraint|Continue|CSByte|CShort|CSng|CStr|CType|CUInt|CULng|CUShort|Custom");
			Add("Date|Decimal|Declare|Default|Delegate|Dim|DirectCast|Distinct|Do|Double");
			Add("Each|Else|ElseIf|End|EndIf|Enum|Equals|Erase|Error|Event|Exit|Explicit");
			Add("False|Finally|For|Friend|From|Function|Get|GetType|GetXMLNamespace|Global|GoSub|GoTo|Group");
			Add("Handles|If|Implements|Imports|In|Inherits|Integer|Interface|Into|Is|IsFalse|IsNot|IsTrue|Join");
			Add("Key|Let|Lib|Like|Long|Loop|Me|Mid|Mod|Module|MustInherit|MustOverride|MyBase|MyClass");
			Add("Namespace|Narrowing|New|Next|Not|Nothing|NotInheritable|NotOverridable");
			Add("Object|Of|Off|On|Operator|Option|Optional|Or|Order|OrElse|Out|Overloads|Overridable|Overrides");
			Add("ParamArray|Partial|Preserve|Private|Property|Protected|Public");
			Add("RaiseEvent|ReadOnly|ReDim|REM|RemoveHandler|Resume|Return|SByte|Select|Set");
			Add("Shadows|Shared|Short|Single|Skip|Static|Statement|Step|Stop|Strict|String|Structure|Sub|SyncLock");
			Add("Take|Text|Then|Throw|To|True|Try|TryCast|TypeOf|UInteger|ULong|Unicode|Until|UShort|Using");
			Add("Variant|Wend|When|Where|While|Widening|With|WithEvents|WriteOnly|Xor");
		}

		// VBScript: keywords (copied from CP list)
		public void AddKeywordsVBScript() {
			Add("Server|Application|Err|Response|Request");
			Add("Dim|ReDim|Private|Public|IsArray|Erase|LBound|UBound|Let|Set|Rem|Empty|Nothing");
			Add("Null|True|False|Do|End|Loop|For|Next|Each|If|Then|Else|Select|Case|While|Wend");
			Add("Abs|Asc|AscB|AscW|Chr|CBool|CByte|CDate|CDbl|CInt|CLng|CSng|CStr");
			Add("DateSerial|DateValue|Hex|Oct|Fix|Int|Sgn|TimeSerial|TimeValue|Date|Time");
			Add("Day|Month|Weekday|Year|Hour|Minute|Second|Now|Dim|Private|Public|ReDim");
			Add("Function|Sub|On|Error|Err|Mod|Is|And|Or|Xor|Eqv|Imp|CreateObject|IsObject");
			Add("Option|Explicit|Call|Function|Sub|Asc|Chr|Instr");
			Add("Len|Lcase|Ucase|Left|Mid|MidB|Right|RightB|Space|StrComp|String");
			Add("Ltrim|Rtrim|Trim|IsArray|IsDate|IsEmpty|IsNull|IsNumeric|IsObject|VarType");
			Add("LeftB|AscB|AscW|ChrB|ChrW|MidB|RightB|InStrB|LenB");
		}
	}
}
