﻿//==============================================================================================
//
//	LanguageXYZ
//	V2.0
//	by Luc Pattyn, January 2010
//
//	class used by LPCodeRecognizer
//
//==============================================================================================
using System;
using System.Collections.Generic;
using System.Text;

namespace LPCodeRecognizer {
	class LanguagePHP : Language {
		public LanguagePHP() : base("php", "", false, 2,
			"many$start|many$start|many$start|many;|many{}|few<start|few@start", "", "") {
			// emphasis: we have triple "few()" to avoid programming languages
			AddKeywordsPHP();
		}

		// PHP: all keywords from http://php.net/manual/en/reserved.keywords.php
		public void AddKeywordsPHP() {
			Add("abstract|and|array|as|break|case|catch|cfunction|class|clone|const|continue");
			Add("declare|default|do|else|elseif|enddeclare|endfor|endforeach|endif|endswitch|endwhile|extends");
			Add("final|for|foreach|function|global|goto|if|implements|interface|instanceof|namespace");
			Add("new|old_function|or|private|protected|public|static|switch|throw|try|use|var|while|xor");
			Add("die|echo|empty|exit|eval|include|include_once|isset|list|require|require_once|return|print|unset");
		}
	}
}
