﻿//==============================================================================================
//
//	LanguageXYZ
//	V2.0
//	by Luc Pattyn, January 2010
//
//	class used by LPCodeRecognizer
//
//==============================================================================================
using System;
using System.Collections.Generic;
using System.Text;

namespace LPCodeRecognizer {
	class LanguageSQL : Language {
		public LanguageSQL()
			: base("sql", "", false, 1, "few$start|few<>|few<start|few;|manyKeywords", 
			"varchar|VARCHAR|select|SELECT|where|WHERE|insert|INSERT|update|UPDATE", "dim|DIM") {
			AddKeywordsSQL();
		}

		// TSQL: all keywords from http://msdn.microsoft.com/en-us/library/ms189822.aspx
		public void AddKeywordsSQL() {
			Add("ADD|ALL|ALTER|AND|ANY|AS|ASC|AUTHORIZATION|BACKUP|BEGIN|BETWEEN");
			Add("BREAK|BROWSE|BULK|BY|CASCADE|CASE|CHECK|CHECKPOINT|CLOSE|CLUSTERED");
			Add("COALESCE|COLLATE|COLUMN|COMMIT|COMPUTE|CONSTRAINT|CONTAINS|CONTAINSTABLE");
			Add("CONTINUE|CONVERT|CREATE|CROSS|CURRENT|CURRENT_DATE|CURRENT_TIME|CURRENT_TIMESTAMP");
			Add("CURRENT_USER|CURSOR|DATABASE|DBCC|DEALLOCATE|DECLARE|DEFAULT|DELETE|DENY");
			Add("DESC|DISK|DISTINCT|DISTRIBUTED|DOUBLE|DROP|DUMP");
			Add("ELSE|END|ERRLVL|ESCAPE|EXCEPT|EXEC|EXECUTE");
			Add("EXISTS|EXIT|EXTERNAL|FETCH|FILE|FILLFACTOR|FOR|FOREIGN|FREETEXT");
			Add("FREETEXTTABLE|FROM|FULL|FUNCTION|GOTO|GRANT|GROUP|HAVING|HOLDLOCK");
			Add("IDENTITY|IDENTITY_INSERT|IDENTITYCOL|IF|IN|INDEX|INNER|INSERT|INTERSECT|INTO|IS");
			Add("JOIN|KEY|KILL|LEFT|LIKE|LINENO|LOAD|MERGE|NATIONAL|NOCHECK|NONCLUSTERED|NOT|NULL|NULLIF");
			Add("OF|OFF|OFFSETS|ON|OPEN|OPENDATASOURCE|OPENQUERY|OPENROWSET|OPENXML|OPTION|OR|ORDER|OUTER|OVER");
			Add("PERCENT|PIVOT|PLAN|PRECISION|PRIMARY|PRINT|PROC|PROCEDURE|PUBLIC");
			Add("RAISERROR|READ|READTEXT|RECONFIGURE|REFERENCES|REPLICATION|RESTORE");
			Add("RESTRICT|RETURN|REVERT|REVOKE|RIGHT|ROLLBACK|ROWCOUNT|ROWGUIDCOL|RULE");
			Add("SAVE|SCHEMA|SECURITYAUDIT|SELECT|SESSION_USER|SET|SETUSER|SHUTDOWN|SOME");
			Add("STATISTICS|SYSTEM_USER");
			Add("TABLE|TABLESAMPLE|TEXTSIZE|THEN|TO|TOP|TRAN|TRANSACTION|TRIGGER|TRUNCATE|TSEQUAL");
			Add("UNION|UNIQUE|UNPIVOT|UPDATE|UPDATETEXT|USE|USER|VALUES|VARYING|VIEW");
			Add("WAITFOR|WHEN|WHERE|WHILE|WITH|WRITETEXT");
		}
	}
}
