﻿using System;
using System.Collections.Generic;
using System.Text;

namespace LPCodeRecognizer {
	public class Untabber {
		public static Action<string> Logger;

		private static void log(string s) {
			if (Logger!=null) Logger(s);
		}

		public static string ReduceLeftTabs(string text) {
			bool visible=false;
			bool spaces=false;
			int minTabs=int.MaxValue;
			int tabs=0;
			foreach (char c in text) {
				switch (c) {
					case '\r':
					case '\n':
						// lines without visible content should not prevent a tab reduction
						if (visible && tabs<minTabs) minTabs=tabs;
						visible=false;
						spaces=false;
						tabs=0;
						break;
					case '\t':
						// only count tabs to the left of first space or visible character
						if (!spaces && !visible) tabs++;
						break;
					case ' ':
						spaces=true;
						break;
					default:
						visible=true;
						break;
				}
			}
			log("minTabs="+minTabs);
			if (minTabs!=0) {
				StringBuilder sb=new StringBuilder(text);
				int removeTabs=minTabs;
				for (int i=0; i<sb.Length; i++) {
					switch (sb[i]) {
						case '\r':
						case '\n':
							removeTabs=minTabs;
							break;
						case '\t':
							if (removeTabs>0) {
								sb.Remove(i, 1);
								i--;
								removeTabs--;
							}
							break;
						default:
							removeTabs=0;
							break;
					}
				}
				text=sb.ToString();
			}
			return text;
		}
	}
}
