//#######################################################################
//
// Form1.cs
// by Luc Pattyn, july 2007
//
// V1.2
// part of LP_IECodeRescue
// published on CodeProject
//
//#######################################################################

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;							// ClipBoard
using System.Drawing;
using System.Media;							// SystemSounds
using System.Runtime.InteropServices;		// DllImport
using System.Text;
using System.Windows.Forms;

using Microsoft.Win32;						// SystemEvents

//
// the hotkey is defined in four places; If one decides to choose
// another hotkey, these must be kept consistent:
//		- adjustHotkey() method			(in this file)
//		- WndProc() method				(in this file)
//		- hotKeyToolStripMenuItem.Text	(thru Visual Designer)
//		- About.label5.Text				(thru Visual Designer)
//

namespace LP_IECodeRescue {
	public partial class Form1 : Form {
		private int hotkeyIdent;

		public Form1() {
			InitializeComponent();
			this.FormClosed+=new FormClosedEventHandler(Form1_FormClosed);
			SystemEvents.SessionEnding+=new SessionEndingEventHandler(SystemEvents_SessionEnding);
			adjustFormVisible(false);	// form initially invisible
			adjustHotkey(true);			// install hotkey (initially active)
#if DEBUG
			// optionally add a menu item so one can choose to show the main form
			this.showFormToolStripMenuItem.Visible=true;
#endif
		}

		// Since we dont have an official main form, we should explicitly
		// connect to the FormClosed event (in case form is visible and
		// gets closed e.g. thru Close Box)
		void Form1_FormClosed(object sender, FormClosedEventArgs e) {
			exit();
		}

		// Since we dont have a main form, we should watch for session endings
		// explicitly
		void SystemEvents_SessionEnding(object sender, SessionEndingEventArgs e) {
			exit();
		}

		// The quit menu handler
		private void quitToolStripMenuItem_Click(object sender, EventArgs e) {
			exit();
		}

		// Terminates the app and performs clean-up
		private void exit() {
			notifyIcon1.Dispose();
			Application.Exit();
		}

		// For debugging purposes we have a ListBox on the (normally invisible)
		// main form
		private void log(string s) {
			lb.Items.Add(s);
			if (Control.MouseButtons==MouseButtons.None) lb.TopIndex=lb.Items.Count-1;
		}

		// The rescue menu handler
		private void rescueCodeToolStripMenuItem_Click(object sender, EventArgs e) {
			RescueCode();
		}

		// The actual rescue operation, called by its menu or its hotkey
		private void RescueCode() {
			bool soundEnabled=soundToolStripMenuItem.Checked;
			ShowClipboardFormats("Clipboard formats before code rescue");
			IDataObject data=Clipboard.GetDataObject();
			// make sure Clipboard holds some text we can rescue
			// IE6/IE7 copying <pre>text</pre> will return four types of data
			if(data.GetDataPresent(DataFormats.Text) &&
				data.GetDataPresent(DataFormats.UnicodeText) &&
				data.GetDataPresent(DataFormats.Rtf) &&
				data.GetDataPresent(DataFormats.Html)) {
				// the heart of the conversion
				rtb.Clear();
				rtb.Paste(DataFormats.GetFormat(DataFormats.Rtf));
				rtb.SelectAll();
				rtb.Copy();
				// that's all !
				ShowClipboardFormats("Clipboard formats after code rescue");
				// success
				if (soundEnabled) SystemSounds.Exclamation.Play();
				return;
			}
			// failure
			if(soundEnabled) SystemSounds.Beep.Play();
		}

		// Logging all formats currently on the clipboard
		private void ShowClipboardFormats(string title) {
			log(title);
			IDataObject data=Clipboard.GetDataObject();
			foreach(string s in data.GetFormats(false)) {
				log("    "+s);
			}
		}

		// Shows the About dialog
		private void aboutToolStripMenuItem_Click(object sender, EventArgs e) {
			About about=new About();
			about.ShowDialog();
		}

		// Handles the (hidden) "Show Form" menu
		private void showFormToolStripMenuItem_Click(object sender, EventArgs e) {
			adjustFormVisible(!showFormToolStripMenuItem.Checked);
		}

		private void adjustFormVisible(bool visible) {
			log("visible="+visible);
			showFormToolStripMenuItem.Checked=visible;
			this.Visible=visible;
			this.ShowInTaskbar=visible;
			//this.WindowState=visible?FormWindowState.Normal:FormWindowState.Minimized;
		}

		// Handles the hotkey menu item
		private void hotKeyToolStripMenuItem_Click(object sender, EventArgs e) {
			adjustHotkey(hotKeyToolStripMenuItem.Checked);
		}

		// installs or removes the hotkey; called by constructor and by menu
		private void adjustHotkey(bool withHotKey) {
			if (withHotKey) {
				hotkeyIdent=SetHotKey(Keys.F2, 2);
			} else {
				RemoveHotKey(ref hotkeyIdent);
			}
		}

		// Sets a hotkey for a Keys and its modifier keys, encoded
		// in an int: 1=Alt, 2=Ctrl, 4=Shift, 8=Win
		// returns the identifier, necessary for future removal
		private int SetHotKey(Keys keyCode, int modifiers) {
			int chr=(int)keyCode;
			// identifier must be unique, so we use a hash code
			int ident=GetType().GetHashCode()+(modifiers<<16)+chr;
			RegisterHotKey(Handle, ident, modifiers, chr);
			// HotKey will generate a WM_HOTKEY message with:
			//	Msg==0x0312 wParam=ident HI(lParam)=chr LO(lParam)=modifiers
			log("hotkey added (chr=0x"+chr.ToString("X2")+")");
			return ident;
		}

		// Removes a hotkey identified by its ident value
		private void RemoveHotKey(ref int ident) {
			if(ident!=0) UnregisterHotKey(Handle, ident);
			ident=0;
			log("hotkey removed");
		}

		// We must intercept the WM_HOTKEY message and check lParam !
		protected override void WndProc(ref Message m) {
			if(m.Msg==0x0312) {	// WM_HOTKEY (winuser.h)
				int lParam=(int)m.LParam;
				if(lParam==0x00710002) RescueCode();			// CTRL+F2
			}
			base.WndProc(ref m);
		}

		// Prototype for Win32 hotkey function
		[DllImport("user32.dll")]
		public static extern bool RegisterHotKey(IntPtr hWnd,
			int id, int fsModifiers, int vlc);

		// Prototype for Win32 hotkey function
		[DllImport("user32.dll")]
		public static extern bool UnregisterHotKey(IntPtr hWnd, int id);
	}
}